<?php

/*
 * 
 */


if (!defined('_PS_VERSION_'))
	exit;
class pinterest extends Module{
    private $_html  = '';
    private $_postErrors = array();
    private $_pinDescription ='';
    private $pinterestCover = '';
    private $_pinCounter = '';
    private $_outputDescription = '';
   
    
    public function __construct() {
        $this->name = 'pinterest';
        $this->tab = 'social_networks';
        $this->version = '1.0';
        $this->author = 'Onasus.com';
        $this->need_instance = 0;
        
        parent::__construct();
        
        $this->displayName = $this->l('Pinterest button');
		$this->description = $this->l('Add a Pinterest button to invite users to publich your product onto Pinterest.');
    }
        
    public function install() {
        if (!parent::install())
            return false;
        
        if (!$this->registerHook('extraLeft'))
            return false;
       
        Configuration::updateValue('PINTEREST_LAYOUT','horizontal');
        Configuration::updateValue('PINTEREST_DESCRIPTION','description');
    }

    public function uninstall() {
        parent::uninstall();
    }
    
    public function getContent(){
        $this->_html .= '<h2>'.$this->displayName.'</h2>';
        
        if(Tools::isSubmit('submit')){
            $this->_postValidation();
            
            if(!sizeof($this->_postErrors)){
                $this->_postProcess();
            }
            else{
                foreach ($this->_postErrors as $error) {
                    $this->_html .= '<div class="alert error">'.$error.'</div>';
                }
            }
        }
        
        $this->_displayForm();
        return $this->_html;
    }


    private function _postValidation(){
        //Nothing really to validate
    }
    
    private function _postProcess(){
        Configuration::updateValue('PINTEREST_LAYOUT', Tools::getValue('pinCounter'));
        Configuration::updateValue('PINTEREST_DESCRIPTION', Tools::getValue('pinDescription'));
    }
    
    
    //Add description option?
    private function _displayForm(){
        $this->_html .= '
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'pinlogo.gif" alt="Pinterest logo" class="middle" />'.$this->l('Pinterest Button Settings').'</legend>
				
				<label>'.$this->l('Click Count').'</label>
				<div class="margin-form">
					<input type="radio" name="pinCounter" value="horizontal"'.(Tools::getValue('pinCounter', Configuration::get('PINTEREST_LAYOUT')) == "horizontal" ? ' checked="checked"' : '').' >horizontal</option>
					<input type="radio" name="pinCounter" value="vertical"'.(Tools::getValue('pinCounter', Configuration::get('PINTEREST_LAYOUT')) == "vertical" ? ' checked="checked"' : '').' >vertical</option>
					<input type="radio" name="pinCounter" value="none"'.(Tools::getValue('pinCounter', Configuration::get('PINTEREST_LAYOUT')) == "none" ? ' checked="checked"' : '').' >none</option>
					<p class="clear"></p>
				</div>
				<label>'.$this->l('Description source').'</label>
				<div class="margin-form">
					<select name = "pinDescription">
					<option value="short_description"'.(Tools::getValue('pinDescription', Configuration::get('PINTEREST_DESCRIPTION')) == "short_description" ? ' SELECTED' : '').' >Short description</option>
					<option value="description"'.(Tools::getValue('pinDescription', Configuration::get('PINTEREST_DESCRIPTION')) == "description" ? ' SELECTED' : '').' >Description</option>					
					</select>
					<p class="clear"></p>
				</div>
			<input type="submit" name="submit" value="'.$this->l('Update').'" class="button" />
			</fieldset>			
		</form>';
                
    }
    
    public function hookExtraLeft($params){
        global $smarty, $link, $cookie;
        //Robots
        if (stripos($_SERVER['HTTP_USER_AGENT'],'bot') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'baidu') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'spider') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'Ask Jeeves') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'slurp') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'crawl') !== false)
			return;
        
        $idProd = (int)Tools::getValue('id_product');
        $prodCover = Product::getCover($idProd);
        
        
        if (is_array($prodCover) && sizeof($prodCover) == 1){
            $product = New Product($idProd);
            $this->pinterestCover  = $link->getImageLink($product->link_rewrite[$cookie->id_lang],$prodCover.'-'.$prodCover['id_image'],'thickbox');
            
            
            // description
            if($this->_pinDescription == 'description'){
                $this->_outputDescription = $product->description[$cookie->id_lang];
            }
            elseif($this->_pinDescription == 'short_description'){
                $this->_outputDescription = $product->description_short[$cookie->id_lang];
            }
        }      
        
        $smarty->assign(
                array(
                    'pin_counter' => Configuration::get('PINTEREST_LAYOUT'),
					'pin_url' => 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'],
                    'pin_pic_url' => $this->pinterestCover,
                    'pin_output_description' => $this->_outputDescription
                    
                )
                );
        
        return $this->display(__FILE__, 'pinterest.php.tpl');
    }
    
    public function hookExtraRight($params){
        return $this->hookExtraLeft($params);
    }
    
    public function hookPinterest($params){
        return $this->hookExtraLeft($params);
    }
    
    public function hookFooter($params){
        return $this->hookExtraLeft($params);
    }
    
    public function hookRight($params){
        return $this->hookExtraLeft($params);
    }
    
    public function hookLeft($params){
        return $this->hookExtraLeft($params);
    }
}
?>
